Rem
Rem $Header: subset_georaster.sql 05-aug-2004.09:30:23 wexu Exp $
Rem
Rem subset_georaster.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      subset_georaster.sql
Rem
Rem    DESCRIPTION
Rem      subset means spatial crop and band/layer subset or 
Rem      duplicate. it also can function as copy and changeFormat
Rem      with appropriate parameters, etc.
Rem
Rem    NOTES
Rem 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/05/04 - RDT must be unique 
Rem    qxie        09/24/03 - optionally add rasterid in init() call 
Rem    qxie        07/22/03 - comments
Rem    wexu        11/04/02 - minor fixes
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/30/02 - Created
Rem

-------------------------------------------------------------------
-- Subset GeoRaster Objects
-- 
-- You can call sdo_geor.subset to crop a small area, subset a few
-- layers of the georaster object. It will create a new georaster
-- object. You can specify various storage format (blocking and
-- interleaving) to store the result georaster object.
-------------------------------------------------------------------

declare
  gr1 mdsys.sdo_georaster;
  gr2 mdsys.sdo_georaster;
  cnt integer := 0;
begin
  --
  -- subset a blank georaster object
  --

  -- 1. initialize an empty georaster to hold the copy
  delete from georaster_table where georid = 8;
  insert into georaster_table
    values (8, 'Blank Subset', sdo_geor.init('ST_RDT_3', 8))
    returning georaster into gr2;

  -- 2. the source blank georaster object
  select georaster into gr1
    from georaster_table where georid = 3 for update;

  -- 3. crop 
  sdo_geor.subset(gr1, 
                  sdo_geometry(2003, NULL, NULL,
                     mdsys.sdo_elem_info_array(1, 1003, 3),
                     mdsys.sdo_ordinate_array(100,256,500,1000)),
                  null, null, gr2);

  -- 4. store it into the georaster table
  update georaster_table set georaster = gr2 where georid = 8;


  --
  -- subset a truecolor georaster object
  --

  -- 1. initialize an empty georaster to hold the subset if not exist
  select count(*) into cnt from georaster_table where georid = 9;
  if (cnt = 0) then
   insert into georaster_table 
     values (9, 'Truecolor Subset', sdo_geor.init('ST_RDT_3', 9));
  end if;
  select georaster into gr2 
    from georaster_table where georid = 9 for update;
 
  -- 2. the source 3-band truecolor georaster object
  select georaster into gr1 from georaster_table where georid = 4;

  -- 3. make crop and subset 2 bands
  sdo_geor.subset(gr1, 
                  sdo_geometry(2003, NULL, NULL,
                    mdsys.sdo_elem_info_array(1, 1003, 3),
                    mdsys.sdo_ordinate_array(100,200,355,455)),
                  '2,1', 'blocksize=(32,32,2)', gr2);

  -- 4. store it into the georaster table
  update georaster_table set georaster = gr2 where georid = 9;

  commit;
end;
/

-- quick check on the results
@query_georaster.sql

select sdo_geor.getCellValue(georaster,0,254,224,1) v1,
       sdo_geor.getCellValue(georaster,0,231,290,1) V2,
       sdo_geor.getCellValue(georaster,0,245,375,1) V3,
       sdo_geor.getCellValue(georaster,0,245,420,1) V4,
       sdo_geor.getCellValue(georaster,0,224,454,1) v5
  from georaster_table where georid=9;


